﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    //gpe object
    clsGPE GPE;

    void ImageEnCoder()
    {
        //your code will need to go here to create a new image file

    }

    protected void Page_Load(object sender, EventArgs e)
    {
        //if this is a re load of the page
        if (IsPostBack == true)
        {
            //get the current state of the program
            GPE = (clsGPE)Session["GPE"];
        }
        else
        {
            //if it is the first time the page has loaded
            //initialise the array
            GPE = new clsGPE(20);
            //update the library combo box
            GPE.DisplayScripts(cboLibrary);
        }
        //set up the screen
        GPE.BuildWebGrid(this.Page);
        //display the array containing the canvas
        GPE.RefreshWebGrid(this.Page);
    }


    protected void Page_UnLoad(object sender, EventArgs e)
    {
        //this event runs each time the page unloads
        //
        //store the state of the program
        Session["GPE"] = GPE;
    }

    protected void btnRun_Click(object sender, EventArgs e)
    {
        //this event runs when the run script button is pressed
        //
        //clear any existing error messages
        txtError.Text = "";
        //call the run script sub procedure 
        GPE.RunScript(txtScript.Text, "");
        //display the canvas array after the script has been run
        GPE.RefreshWebGrid(this.Page);
        //display the current x position of the pen
        lblX.Text = "X=" + GPE.X;
        //display the current y position of the pen
        lblY.Text = "Y=" + GPE.Y;
        //display the ink colour
        lblInk.Text = GPE.Ink;
        //display any errors
        txtError.Text = GPE.ErrString;
    }
    protected void cboLibrary_SelectedIndexChanged(object sender, EventArgs e)
    {
        //this code runs each time the user makes a change to the selection on the drop down list
        //
        //load the script to the interface
        txtScript.Text = GPE.LoadScript(cboLibrary.SelectedValue);
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //call the coder for the graphic file
        ImageEnCoder();
    }
    protected void btnView_Click(object sender, EventArgs e)
    {
        //display the mog file in the viewer
        Response.Redirect("Reader.aspx?FileName=" + cboLibrary.Text.Replace(".txt", ".mog"));
    }
}

